/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.api;

import ht.treechop.api.BlockMatcher;
import ht.treechop.api.ITreeBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.chop.LazyTreeData;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.util.BlockNeighbors;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class TreeDetectorBuilder {
    private BlockMatcher logMatcher = ChopUtil::isBlockALog;
    private BlockMatcher leavesMatcher = ChopUtil::isBlockLeaves;
    private BiFunction<class_1937, class_2338, Stream<class_2338>> treeScanner = (level, pos) -> BlockNeighbors.HORIZONTAL_AND_ABOVE.asStream((class_2338)pos);
    private BiFunction<class_1937, class_2338, Stream<class_2338>> leavesScanner = (level, pos) -> BlockNeighbors.ADJACENTS.asStream((class_2338)pos);
    private int maxLogs;
    private int maxLeavesDistance;
    private LeavesStrategy leavesStrategy = LeavesStrategy.SMART;

    public TreeDetectorBuilder() {
        this.maxLogs = (Integer)ConfigHandler.COMMON.maxNumTreeBlocks.get();
        this.maxLeavesDistance = (Integer)ConfigHandler.COMMON.maxBreakLeavesDistance.get();
    }

    public TreeDetectorBuilder logs(BlockMatcher logMatcher) {
        this.logMatcher = logMatcher;
        return this;
    }

    public TreeDetectorBuilder leaves(BlockMatcher leavesMatcher) {
        this.leavesMatcher = leavesMatcher;
        return this;
    }

    public TreeDetectorBuilder treeScanner(BiFunction<class_1937, class_2338, Stream<class_2338>> scanner) {
        this.treeScanner = scanner;
        return this;
    }

    public TreeDetectorBuilder leavesScanner(BiFunction<class_1937, class_2338, Stream<class_2338>> scanner) {
        this.leavesScanner = scanner;
        return this;
    }

    public TreeDetectorBuilder maxLogCount(int maxLogs) {
        this.maxLogs = maxLogs;
        return this;
    }

    public TreeDetectorBuilder maxLeavesDistance(int maxLeavesDistance) {
        this.maxLeavesDistance = maxLeavesDistance;
        return this;
    }

    public TreeDetectorBuilder leavesStrategy(LeavesStrategy strategy) {
        this.leavesStrategy = strategy;
        return this;
    }

    public ITreeBlock build() {
        return (level, origin) -> new LazyTreeData(level, origin, pos -> this.treeScanner.apply(level, (class_2338)pos), pos -> this.leavesScanner.apply(level, (class_2338)pos), pos -> this.logMatcher.matches(level, (class_2338)pos, ChopUtil.getLogState(level, pos)), pos -> this.leavesMatcher.matches(level, (class_2338)pos, level.method_8320(pos)), this.maxLogs, this.maxLeavesDistance, this.leavesStrategy == LeavesStrategy.SMART);
    }

    public static enum LeavesStrategy {
        SMART,
        SHORTEST_PATH;

    }
}

